package gov.va.vamf.scheduling.varutility.datalayer;

import gov.va.vamf.scheduling.varutility.domain.Institution;
import gov.va.vamf.scheduling.varutility.utils.DAOConstants;

import org.springframework.jdbc.core.JdbcTemplate;

import java.util.HashMap;
import java.util.Map;
import java.util.List;

public class InstitutionDao {

    private InstitutionStoredProcedure institutionStoredProcedure;
    private JdbcTemplate jdbcTemplate;
    private String storedProcedure;
    private InstitutionResultSetRowMapper institutionResultSetRowMapper;

    public void initStoredProcedure() {
        institutionStoredProcedure = new InstitutionStoredProcedure(jdbcTemplate, storedProcedure, institutionResultSetRowMapper);
    }

    public List<Institution> getInstitutionsBySiteCode(String siteCode) {
        Map<String, Object> inputParamsMap = new HashMap<String, Object>();
        inputParamsMap.put(DAOConstants.STATIONS, siteCode);

        return executeStoredProcedure(inputParamsMap);
    }

    private List<Institution> executeStoredProcedure(Map<String, Object> inputParamsMap) {
        Map<String, Object> storedProcedureResults = institutionStoredProcedure.getStoredProcedureResults(inputParamsMap);
        return (List<Institution>) storedProcedureResults.get(DAOConstants.RESULT_LIST);
    }

    public InstitutionStoredProcedure getInstitutionStoredProcedure() {
        return institutionStoredProcedure;
    }

    public void setInstitutionStoredProcedure(InstitutionStoredProcedure institutionStoredProcedure) {
        this.institutionStoredProcedure = institutionStoredProcedure;
    }

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getStoredProcedure() {
        return storedProcedure;
    }

    public void setStoredProcedure(String storedProcedure) {
        this.storedProcedure = storedProcedure;
    }

    public InstitutionResultSetRowMapper getInstitutionResultSetRowMapper() {
        return institutionResultSetRowMapper;
    }

    public void setInstitutionResultSetRowMapper(InstitutionResultSetRowMapper institutionResultSetRowMapper) {
        this.institutionResultSetRowMapper = institutionResultSetRowMapper;
    }
}
